include(CheckTypeSize)

macro(check_type_size_n _wordlist n output)
  set(${output} "")
  set(HAVE_${output} 0)
  foreach(flag ${_wordlist})
    string(REGEX REPLACE "[-+/ ()]" "_" flagname "${flag}")
    string(TOUPPER "${flagname}" flagname)
    check_type_size("${flag}" SIZEOF_${flagname})
    if("${SIZEOF_${flagname}}" STREQUAL "${n}")
      set(${output} "${flag}")
      set(HAVE_${output} 1)
      break()
    endif("${SIZEOF_${flagname}}" STREQUAL "${n}")
  endforeach(flag)
endmacro(check_type_size_n)
